using System;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      /*
         Note that the dynapdf.dll must be copied into the output directory or into a
         Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
      */

      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
         try
         {
            double x, y;
            int act, lnk, f, bmk, root;
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We open the output file later if no error occurrs.

            pdf.SetPageCoords(TPageCoord.pcTopDown);

            pdf.SetPageHeight(500.0);
            pdf.SetPageWidth(800.0);

            pdf.Append();
               f = pdf.SetFont("Helvetica", TFStyle.fsRegular, 20, false, TCodepage.cp1252);
               pdf.WriteText(50, 50, "Bookmark destination type dtFit");
               root = pdf.AddBookmark("DestType dtFit", -1, 1, true);
               pdf.SetBookmarkDest(root, TDestType.dtFit, 0, 0, 0, 0);
               pdf.SetBookmarkStyle(root, TFStyle.fsItalic, CPDF.PDF_RED);
            pdf.EndPage();

            pdf.Append();
               pdf.ChangeFont(f);
               pdf.WriteText(50, 50, "Bookmark destination type dtXY_Zoom");
               pdf.WriteText(50, 70, "Zoom factor 3, Top position 50 (TopDown coordinates)");
               bmk = pdf.AddBookmark("DestType: dtXY_Zoom, zoom factor 3", root, 2, false);
               pdf.SetBookmarkDest(bmk, TDestType.dtXY_Zoom, 50, 50, 3, 0);
               pdf.SetBookmarkStyle(bmk, TFStyle.fsBold, CPDF.PDF_MAROON);
            pdf.EndPage();

            pdf.Append();
               pdf.ChangeFont(f);
               pdf.WriteText(50, 50, "Bookmark destination type dtXY_Zoom");
               pdf.WriteText(50, 70, "Zoom factor 0.5, Top position 50 (TopDown coordinates)");
               bmk = pdf.AddBookmark("DestType: dtXY_Zoom, zoom factor 0.5", root, 3, false);
               pdf.SetBookmarkDest(bmk, TDestType.dtXY_Zoom, 50, 50, 0.5, 0);
               pdf.SetBookmarkStyle(bmk, TFStyle.fsBold | TFStyle.fsItalic, CPDF.PDF_GREEN);
            pdf.EndPage();

            pdf.Append();
               pdf.ChangeFont(f);
               pdf.WriteText(50, 50, "Bookmark destination type dtXY_Zoom");
               pdf.WriteText(50, 70, "Zoom factor not defined (unchanged), Top position 50 (TopDown coordinates)");
               bmk = pdf.AddBookmark("DestType: dtXY_Zoom, zoom factor unchanged", root, 4, false);
               pdf.SetBookmarkDest(bmk, TDestType.dtXY_Zoom, 50, 50, 0, 0);
               pdf.SetBookmarkStyle(bmk, TFStyle.fsRegular, CPDF.PDF_BLUE);
            pdf.EndPage();

            pdf.Append();
               pdf.ChangeFont(f);
               pdf.WriteText(50, 50, "Bookmark destination type dtFitH_Top");
               pdf.WriteText(50, 70, "Top position 50 (TopDown coordinates)");
               bmk = pdf.AddBookmark("DestType: dtFitH_Top (50)", root, 5, false);
               pdf.SetBookmarkDest(bmk, TDestType.dtFitH_Top, 50, 0, 0, 0);
               pdf.SetBookmarkStyle(bmk, TFStyle.fsRegular, 0x00FF8080);
               pdf.WriteText(50, 200, "Bookmark destination type dtFitH_Top");
               pdf.WriteText(50, 220, "Top position 200 (TopDown coordinates)");
               bmk = pdf.AddBookmark("DestType dtFitH_Top (200)", root, 5, false);
               pdf.SetBookmarkDest(bmk, TDestType.dtFitH_Top, 200, 0, 0, 0);
               pdf.SetBookmarkStyle(bmk, TFStyle.fsRegular, 0x00C08080);
            pdf.EndPage();

            pdf.Append();
               pdf.ChangeFont(f);
               pdf.WriteText(200, 50, "Bookmark destination type dtFitV_Left");
               pdf.WriteText(200, 70, "Left position 200. FitV has no effect if the width of the page");
               pdf.WriteText(200, 90, "is not greater as the height.");
               bmk = pdf.AddBookmark("DestType: dtFitV_Left (200)", root, 6, false);
               pdf.SetBookmarkDest(bmk, TDestType.dtFitV_Left, 200, 0, 0, 0);
               pdf.SetBookmarkStyle(bmk, TFStyle.fsRegular, 0x00808FFF);
            pdf.EndPage();

            pdf.Append();
               pdf.ChangeFont(f);
               pdf.WriteText(50, 50, "Bookmark destination type dtFit_Rect");
               x = (pdf.GetPageWidth()  -90.0) / 2.0;
               y = (pdf.GetPageHeight() -65.0) / 2.0;

               pdf.WriteFTextEx(x, y, 90.0, -1, TTextAlign.taCenter, "We zoom into the rectangle");
               pdf.Rectangle(x, y, 90.0, 65.0, TPathFillMode.fmStroke);

               // We place a page link with a GoTo action on this position. The link zooms into the rectangle in the same way as the bookmark.
               pdf.SetLinkHighlightMode(THighlightMode.hmInvert);
               lnk = pdf.PageLink(x, y, 90, 65, 7);
               act = pdf.CreateGoToAction(TDestType.dtFit_Rect, 7, x - 5.0, y - 5.0, x + 100.0, y + 70.0);
               pdf.AddActionToObj(TObjType.otPageLink, TObjEvent.oeOnMouseUp, act, lnk);

               bmk = pdf.AddBookmark("DestType: dtFit_Rect", -1, 7, false);
               // The page link uses the same destination as the bookmark should use. So we add the action to the bookmark instead
               // of a bookmark destination. This saves just a little bit disk space.
               pdf.AddActionToObj(TObjType.otBookmark, TObjEvent.oeOnMouseUp, act, bmk);
               pdf.SetBookmarkStyle(bmk, TFStyle.fsRegular, 0x000080FF);
            pdf.EndPage();

            pdf.SetPageFormat(TPageFormat.pfDIN_A4);
            pdf.Append();
               pdf.ChangeFont(f);
               pdf.WriteFTextEx(50.0, 50.0, pdf.GetPageWidth() - 100.0, -1.0, TTextAlign.taLeft, "Destination type dtFit. This variant scales the page so that both sides fit into the viewer window.");
            pdf.EndPage();

            root = pdf.AddBookmark("DestType dtFit", -1, 8, false);
            pdf.SetBookmarkDest(root, TDestType.dtFit, 0, 0, 0, 0);

            bmk  = pdf.AddBookmark("DestType: dtXY_Zoom, zoom factor 3", root, 2, false);
            pdf.SetBookmarkDest(bmk, TDestType.dtXY_Zoom, 50, 50, 3, 0);
            pdf.SetBookmarkStyle(bmk, TFStyle.fsBold, CPDF.PDF_MAROON);


            pdf.SetPageLayout(TPageLayout.plOneColumn);

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
